/*****************************************************************************
*  LPC154x 2ch PWM program for LPCXpresso board
*
*  1. Use SCT0_IN0 input from switch(SW1)
*  2. SCT0_OUT0 is linked to P0_3 (Green Led)
*  3. SCT0_OUT1 is linked to P0_25 (Red Led)
*  4. The green Led flashes with short duty cycle while the red led flashed with
*  	  long duty cycle.
*****************************************************************************/
#include "board.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/
#define match_green_OFF     (5000000)
#define match_green_ON      (4000000)
#define match_red_OFF       (9000000)
#define match_red_ON        (1000000)
#define delay               (10000000)

/*****************************************************************************
 * Private functions
 ****************************************************************************/
void SCT0_Init(void);
/*****************************************************************************
 * Public functions
 ****************************************************************************/

void SCT0_Init(void)
{
	Chip_SCT_Init(LPC_SCT0);													// enable the SCT0 clock

	Chip_SCT_Config(LPC_SCT0, SCT_CONFIG_32BIT_COUNTER |
                            SCT_CONFIG_AUTOLIMIT_L );							// unified timer and auto limit


	Chip_SCT_SetMatchReload(LPC_SCT0, SCT_MATCH_0, delay);						      // match_cycle
	Chip_SCT_SetMatchReload(LPC_SCT0, SCT_MATCH_1, match_green_OFF);			  // match_green_OFF
	Chip_SCT_SetMatchReload(LPC_SCT0, SCT_MATCH_2, match_green_ON);				  // match_green_ON
	Chip_SCT_SetMatchReload(LPC_SCT0, SCT_MATCH_3, match_red_OFF);				  // match_red_OFF
	Chip_SCT_SetMatchReload(LPC_SCT0, SCT_MATCH_4, match_red_ON);				    // match_red_ON

	Chip_SCT_EventState(LPC_SCT0, SCT_EVENT_0, ENABLE_STATE0);					    // event 0 happens in state 0
	Chip_SCT_EventControl(LPC_SCT0, SCT_EVENT_0 , (CHIP_SCT_EVENTCTRL_T) (	SCT_EVECTRL_MATCH0|			// related to match_cycle
                                                                          SCT_IOCOND_LOW	  |			// IN_0 low
                                                                          SCT_COMBMODE_AND  |			// match AND IO condition
                                                                          SCT_STATELD_1	    |			// STATEV is loaded into state
                                                                          SCT_STATEEV_1	    ));		// new state is 1


	Chip_SCT_EventState(LPC_SCT0, SCT_EVENT_1, ENABLE_STATE0); 					    // event 1 happens in state 0
	Chip_SCT_EventControl(LPC_SCT0, SCT_EVENT_1 , (CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH3 |
                                                                          SCT_COMBMODE_MATCH ));  		// match_red_OFF only condition


	Chip_SCT_EventState(LPC_SCT0, SCT_EVENT_2, ENABLE_STATE0); 					    // event 2 happens in state 0
	Chip_SCT_EventControl(LPC_SCT0, SCT_EVENT_2,  (CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH4	|
                                                                          SCT_COMBMODE_MATCH	));			// match_red_ON only condition

	Chip_SCT_EventState(LPC_SCT0, SCT_EVENT_3, ENABLE_STATE1); 					    // event 3 happens in state 1
	Chip_SCT_EventControl(LPC_SCT0, SCT_EVENT_3, (CHIP_SCT_EVENTCTRL_T) (   SCT_EVECTRL_MATCH0	|			  // related to match_cycle
                                                                          SCT_IOCOND_HIGH	    |			  // IN_0 high
                                                                          SCT_COMBMODE_AND	  |			  // match AND IO condition
                                                                          SCT_STATELD_1		    |			  // STATEV is loaded into state
                                                                          SCT_STATEEV_0		    ));			// new state is 0


	Chip_SCT_EventState(LPC_SCT0, SCT_EVENT_4, ENABLE_STATE1); 					    // event 4 happens in state 1
	Chip_SCT_EventControl(LPC_SCT0, SCT_EVENT_4, (CHIP_SCT_EVENTCTRL_T) (   SCT_EVECTRL_MATCH2	 |
                                                                          SCT_COMBMODE_MATCH   ));			// match_green_ON only condition

	Chip_SCT_EventState(LPC_SCT0, SCT_EVENT_5, ENABLE_STATE1); 					    // event 5 happens in state 1
	Chip_SCT_EventControl(LPC_SCT0, SCT_EVENT_5, (CHIP_SCT_EVENTCTRL_T) (   SCT_EVECTRL_MATCH1	 |			// match_green_OFF only condition
                                                                          SCT_COMBMODE_MATCH	 ));

	Chip_SCT_SetOutput(LPC_SCT0, SCT_OUTPUT_0,  (CHIP_SCT_EVENT_T)  (    SCT_EVT_0 |
                                                                       SCT_EVT_3 |
                                                                       SCT_EVT_5 )); 					      // event 0, 3 and 5 set OUT0 (green LED)

	Chip_SCT_ClearOutput(LPC_SCT0, SCT_OUTPUT_0, SCT_EVT_4);					      // event 4 clear OUT0 (green LED)

	Chip_SCT_SetOutput(LPC_SCT0, SCT_OUTPUT_1, (CHIP_SCT_EVENT_T)  (  SCT_EVT_0 |
                                                                    SCT_EVT_1 |
                                                                    SCT_EVT_3 ));						      // event 0, 1 and 3 set OUT1 (red LED)

	Chip_SCT_ClearOutput(LPC_SCT0, SCT_OUTPUT_1, SCT_EVT_2);					// event 2 clear OUT1 (red LED)

	Chip_SCT_Output(LPC_SCT0, 0x0F );     										// default set OUT0 and OUT1

	Chip_SCT_ClearControl(LPC_SCT0,SCT_CTRL_HALT_L);	   						// unhalt it by clearing bit 2 of the CTRL register
}



int main(void)
{
	SystemCoreClockUpdate();
	Board_Init();

	Chip_Clock_SetSysClockDiv(6);


	Chip_Clock_EnablePeriphClock((CHIP_SYSCTL_CLOCK_T) ( SYSCTL_CLOCK_SWM 	  | 		// enable SWM clock
                                                             SYSCTL_CLOCK_GPIO0   |		// enable GPIO port 0 clock
                                                             SYSCTL_CLOCK_GPIO1	  | 	        // enable GPIO port 1 clock
                                                             SYSCTL_CLOCK_MUX 	  |		// enable MUX clock
                                                             SYSCTL_CLOCK_IOCON	));             //enable IOCON clock


	Chip_SWM_MovablePortPinAssign(SWM_SCT0_OUT0_O , 0, 3);			//SCT0_OUT0 = P0.3 = green LED
	Chip_SWM_MovablePortPinAssign(SWM_SCT0_OUT1_O , 0, 25);			//SCT0_OUT1 = P0.25  = red   LED

    Chip_INMUX_SelectSCT0Src(0, SCT0_INMUX_PIO0_17);				// SCT0_IN2  = P0.17 = SW1

    SCT0_Init();                                          			// Initialize SCT0

    while (1)                                              			// loop forever
    {
    	__WFI();
    }
}
